/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.item.armor;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.ItemInit;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class GildedNetheriteArmor
extends ArmorItem {
    public GildedNetheriteArmor(ArmorMaterial material, ArmorItem.Type type) {
        super(material, type, new Item.Properties().m_41486_());
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
        if (ConfigInit.CONFIG.allow_extra_tooltips) {
            tooltip.add((Component)Component.m_237115_((String)"item.adventurez.moreinfo.tooltip"));
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                tooltip.remove(Component.m_237115_((String)"item.adventurez.moreinfo.tooltip"));
                tooltip.add((Component)Component.m_237115_((String)"item.adventurez.gilded_netherite_armor.tooltip"));
                tooltip.add((Component)Component.m_237115_((String)"item.adventurez.gilded_netherite_armor.tooltip2"));
                tooltip.add((Component)Component.m_237115_((String)"item.adventurez.gilded_netherite_armor.tooltip3"));
                tooltip.add((Component)Component.m_237115_((String)"item.adventurez.gilded_netherite_armor.tooltip4"));
            }
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        CompoundTag tag;
        if (stack.m_41720_() == ItemInit.GILDED_NETHERITE_CHESTPLATE && (tag = stack.m_41783_()) != null && tag.m_128441_("armor_time")) {
            if (tag.m_128471_("activating_armor") && tag.m_128451_("armor_time") + ConfigInit.CONFIG.gilded_netherite_armor_effect_duration * 2 < (int)world.m_46467_()) {
                tag.m_128379_("activating_armor", false);
            }
            if (tag.m_128471_("activating_armor") && tag.m_128451_("armor_time") + ConfigInit.CONFIG.gilded_netherite_armor_effect_duration < (int)world.m_46467_()) {
                entity.m_7311_(0);
                tag.m_128379_("activating_armor_visuals", false);
            }
        }
    }

    public static void activateStoneGolemArmor(Player player, ItemStack stack) {
        if (!stack.m_150930_(ItemInit.GILDED_NETHERITE_CHESTPLATE)) {
            return;
        }
        MobEffectInstance statusEffectInstance = new MobEffectInstance(MobEffect.m_19453_((int)12), ConfigInit.CONFIG.gilded_netherite_armor_effect_duration, 0, false, false);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("activating_armor")) {
            if (!tag.m_128471_("activating_armor")) {
                tag.m_128379_("activating_armor", true);
                tag.m_128379_("activating_armor_visuals", true);
                tag.m_128405_("armor_time", (int)player.m_9236_().m_46467_());
                if (!player.m_9236_().m_5776_()) {
                    player.m_7292_(statusEffectInstance);
                }
                player.m_6330_(SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            tag.m_128379_("activating_armor", true);
            tag.m_128379_("activating_armor_visuals", true);
            tag.m_128405_("armor_time", (int)player.m_9236_().m_46467_());
            stack.m_41751_(tag);
            player.m_7292_(statusEffectInstance);
            player.m_6330_(SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static boolean isStoneGolemArmorActive(ItemStack stack) {
        if (!stack.m_150930_(ItemInit.GILDED_NETHERITE_CHESTPLATE)) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("armor_time") && tag.m_128441_("activating_armor") && tag.m_128471_("activating_armor_visuals");
    }

    public static boolean fullGolemArmor(Player playerEntity) {
        return playerEntity.m_6844_(EquipmentSlot.HEAD).m_41720_().equals(ItemInit.GILDED_NETHERITE_HELMET) && playerEntity.m_6844_(EquipmentSlot.CHEST).m_41720_().equals(ItemInit.GILDED_NETHERITE_CHESTPLATE) && playerEntity.m_6844_(EquipmentSlot.LEGS).m_41720_().equals(ItemInit.GILDED_NETHERITE_LEGGINGS) && playerEntity.m_6844_(EquipmentSlot.FEET).m_41720_().equals(ItemInit.GILDED_NETHERITE_BOOTS);
    }
}

